/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot.crypto;

public class Shannon {
    private static final int N = 16;
    private static final int FOLD = 16;
    private static final int INITKONST = 1771488570;
    private static final int KEYP = 13;
    private int[] R = new int[16];
    private int[] CRC = new int[16];
    private int[] initR = new int[16];
    private int konst;
    private int sbuf;
    private int mbuf;
    private int nbuf;

    private int sbox(int i) {
        i ^= Integer.rotateLeft(i, 5) | Integer.rotateLeft(i, 7);
        i ^= Integer.rotateLeft(i, 19) | Integer.rotateLeft(i, 22);
        return i;
    }

    private int sbox2(int i) {
        i ^= Integer.rotateLeft(i, 7) | Integer.rotateLeft(i, 22);
        i ^= Integer.rotateLeft(i, 5) | Integer.rotateLeft(i, 19);
        return i;
    }

    private void cycle() {
        int t = this.R[12] ^ this.R[13] ^ this.konst;
        t = this.sbox(t) ^ Integer.rotateLeft(this.R[0], 1);
        for (int i = 1; i < 16; ++i) {
            this.R[i - 1] = this.R[i];
        }
        this.R[15] = t;
        t = this.sbox2(this.R[2] ^ this.R[15]);
        this.R[0] = this.R[0] ^ t;
        this.sbuf = t ^ this.R[8] ^ this.R[12];
    }

    private void crcFunc(int i) {
        int t = this.CRC[0] ^ this.CRC[2] ^ this.CRC[15] ^ i;
        for (int j = 1; j < 16; ++j) {
            this.CRC[j - 1] = this.CRC[j];
        }
        this.CRC[15] = t;
    }

    private void macFunc(int i) {
        this.crcFunc(i);
        this.R[13] = this.R[13] ^ i;
    }

    private void initState() {
        this.R[0] = 1;
        this.R[1] = 1;
        for (int i = 2; i < 16; ++i) {
            this.R[i] = this.R[i - 1] + this.R[i - 2];
        }
        this.konst = 1771488570;
    }

    private void saveState() {
        for (int i = 0; i < 16; ++i) {
            this.initR[i] = this.R[i];
        }
    }

    private void reloadState() {
        for (int i = 0; i < 16; ++i) {
            this.R[i] = this.initR[i];
        }
    }

    private void genKonst() {
        this.konst = this.R[0];
    }

    private void addKey(int k) {
        this.R[13] = this.R[13] ^ k;
    }

    private void diffuse() {
        for (int i = 0; i < 16; ++i) {
            this.cycle();
        }
    }

    private void loadKey(byte[] key) {
        int t;
        int i;
        byte[] extra = new byte[4];
        for (i = 0; i < (key.length & 0xFFFFFFFC); i += 4) {
            t = (key[i + 3] & 0xFF) << 24 | (key[i + 2] & 0xFF) << 16 | (key[i + 1] & 0xFF) << 8 | key[i] & 0xFF;
            this.addKey(t);
            this.cycle();
        }
        if (i < key.length) {
            int j = 0;
            while (i < key.length) {
                extra[j++] = key[i];
                ++i;
            }
            while (j < 4) {
                extra[j] = 0;
                ++j;
            }
            t = (extra[3] & 0xFF) << 24 | (extra[2] & 0xFF) << 16 | (extra[1] & 0xFF) << 8 | extra[0] & 0xFF;
            this.addKey(t);
            this.cycle();
        }
        this.addKey(key.length);
        this.cycle();
        for (i = 0; i < 16; ++i) {
            this.CRC[i] = this.R[i];
        }
        this.diffuse();
        for (i = 0; i < 16; ++i) {
            int n = i;
            this.R[n] = this.R[n] ^ this.CRC[i];
        }
    }

    public void key(byte[] key) {
        this.initState();
        this.loadKey(key);
        this.genKonst();
        this.saveState();
        this.nbuf = 0;
    }

    public void nonce(byte[] nonce) {
        this.reloadState();
        this.konst = 1771488570;
        this.loadKey(nonce);
        this.genKonst();
        this.nbuf = 0;
    }

    public void stream(byte[] buffer) {
        int n;
        int i = 0;
        for (n = buffer.length; this.nbuf != 0 && n != 0; --n) {
            int n2 = i++;
            buffer[n2] = (byte)(buffer[n2] ^ this.sbuf & 0xFF);
            this.sbuf >>= 8;
            this.nbuf -= 8;
        }
        int j = n & 0xFFFFFFFC;
        while (i < j) {
            this.cycle();
            int n3 = i + 3;
            buffer[n3] = (byte)(buffer[n3] ^ this.sbuf >> 24 & 0xFF);
            int n4 = i + 2;
            buffer[n4] = (byte)(buffer[n4] ^ this.sbuf >> 16 & 0xFF);
            int n5 = i + 1;
            buffer[n5] = (byte)(buffer[n5] ^ this.sbuf >> 8 & 0xFF);
            int n6 = i;
            buffer[n6] = (byte)(buffer[n6] ^ this.sbuf & 0xFF);
            i += 4;
        }
        if ((n &= 3) != 0) {
            this.cycle();
            this.nbuf = 32;
            while (this.nbuf != 0 && n != 0) {
                int n7 = i++;
                buffer[n7] = (byte)(buffer[n7] ^ this.sbuf & 0xFF);
                this.sbuf >>= 8;
                this.nbuf -= 8;
                --n;
            }
        }
    }

    public void macOnly(byte[] buffer) {
        int n;
        int i = 0;
        if (this.nbuf != 0) {
            for (n = buffer.length; this.nbuf != 0 && n != 0; --n) {
                this.mbuf ^= buffer[i++] << 32 - this.nbuf;
                this.nbuf -= 8;
            }
            if (this.nbuf != 0) {
                return;
            }
            this.macFunc(this.mbuf);
        }
        int j = n & 0xFFFFFFFC;
        while (i < j) {
            this.cycle();
            int t = (buffer[i + 3] & 0xFF) << 24 | (buffer[i + 2] & 0xFF) << 16 | (buffer[i + 1] & 0xFF) << 8 | buffer[i] & 0xFF;
            this.macFunc(t);
            i += 4;
        }
        if ((n &= 3) != 0) {
            this.cycle();
            this.mbuf = 0;
            this.nbuf = 32;
            while (this.nbuf != 0 && n != 0) {
                this.mbuf ^= buffer[i++] << 32 - this.nbuf;
                this.nbuf -= 8;
                --n;
            }
        }
    }

    public void encrypt(byte[] buffer) {
        this.encrypt(buffer, buffer.length);
    }

    public void encrypt(byte[] buffer, int n) {
        int i = 0;
        if (this.nbuf != 0) {
            while (this.nbuf != 0 && n != 0) {
                this.mbuf ^= (buffer[i] & 0xFF) << 32 - this.nbuf;
                int n2 = i++;
                buffer[n2] = (byte)(buffer[n2] ^ this.sbuf >> 32 - this.nbuf & 0xFF);
                this.nbuf -= 8;
                --n;
            }
            if (this.nbuf != 0) {
                return;
            }
            this.macFunc(this.mbuf);
        }
        int j = n & 0xFFFFFFFC;
        while (i < j) {
            this.cycle();
            int t = (buffer[i + 3] & 0xFF) << 24 | (buffer[i + 2] & 0xFF) << 16 | (buffer[i + 1] & 0xFF) << 8 | buffer[i] & 0xFF;
            this.macFunc(t);
            buffer[i + 3] = (byte)((t ^= this.sbuf) >> 24 & 0xFF);
            buffer[i + 2] = (byte)(t >> 16 & 0xFF);
            buffer[i + 1] = (byte)(t >> 8 & 0xFF);
            buffer[i] = (byte)(t & 0xFF);
            i += 4;
        }
        if ((n &= 3) != 0) {
            this.cycle();
            this.mbuf = 0;
            this.nbuf = 32;
            while (this.nbuf != 0 && n != 0) {
                this.mbuf ^= (buffer[i] & 0xFF) << 32 - this.nbuf;
                int n3 = i++;
                buffer[n3] = (byte)(buffer[n3] ^ this.sbuf >> 32 - this.nbuf & 0xFF);
                this.nbuf -= 8;
                --n;
            }
        }
    }

    public void decrypt(byte[] buffer) {
        this.decrypt(buffer, buffer.length);
    }

    public void decrypt(byte[] buffer, int n) {
        int i = 0;
        if (this.nbuf != 0) {
            while (this.nbuf != 0 && n != 0) {
                int n2 = i;
                buffer[n2] = (byte)(buffer[n2] ^ this.sbuf >> 32 - this.nbuf & 0xFF);
                this.mbuf ^= (buffer[i] & 0xFF) << 32 - this.nbuf;
                ++i;
                this.nbuf -= 8;
                --n;
            }
            if (this.nbuf != 0) {
                return;
            }
            this.macFunc(this.mbuf);
        }
        int j = n & 0xFFFFFFFC;
        while (i < j) {
            this.cycle();
            int t = (buffer[i + 3] & 0xFF) << 24 | (buffer[i + 2] & 0xFF) << 16 | (buffer[i + 1] & 0xFF) << 8 | buffer[i] & 0xFF;
            this.macFunc(t ^= this.sbuf);
            buffer[i + 3] = (byte)(t >> 24 & 0xFF);
            buffer[i + 2] = (byte)(t >> 16 & 0xFF);
            buffer[i + 1] = (byte)(t >> 8 & 0xFF);
            buffer[i] = (byte)(t & 0xFF);
            i += 4;
        }
        if ((n &= 3) != 0) {
            this.cycle();
            this.mbuf = 0;
            this.nbuf = 32;
            while (this.nbuf != 0 && n != 0) {
                int n3 = i;
                buffer[n3] = (byte)(buffer[n3] ^ this.sbuf >> 32 - this.nbuf & 0xFF);
                this.mbuf ^= (buffer[i] & 0xFF) << 32 - this.nbuf;
                ++i;
                this.nbuf -= 8;
                --n;
            }
        }
    }

    public void finish(byte[] buffer) {
        this.finish(buffer, buffer.length);
    }

    public void finish(byte[] buffer, int n) {
        int j;
        int i = 0;
        if (this.nbuf != 0) {
            this.macFunc(this.mbuf);
        }
        this.cycle();
        this.addKey(0x6996C53A ^ this.nbuf << 3);
        this.nbuf = 0;
        for (j = 0; j < 16; ++j) {
            int n2 = j;
            this.R[n2] = this.R[n2] ^ this.CRC[j];
        }
        this.diffuse();
        while (n > 0) {
            this.cycle();
            if (n >= 4) {
                buffer[i + 3] = (byte)(this.sbuf >> 24 & 0xFF);
                buffer[i + 2] = (byte)(this.sbuf >> 16 & 0xFF);
                buffer[i + 1] = (byte)(this.sbuf >> 8 & 0xFF);
                buffer[i] = (byte)(this.sbuf & 0xFF);
                n -= 4;
                i += 4;
                continue;
            }
            for (j = 0; j < n; ++j) {
                buffer[i + j] = (byte)(this.sbuf >> i * 8 & 0xFF);
            }
        }
    }
}

