/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import xyz.gianlu.librespot.common.Utils;

public class BytesArrayList
implements Iterable<byte[]> {
    private byte[][] elementData;
    private int size;

    public BytesArrayList() {
        this.size = 0;
        this.elementData = new byte[5][];
    }

    private BytesArrayList(byte[][] buffer) {
        this.elementData = buffer;
        this.size = buffer.length;
    }

    @NotNull
    public static InputStream streamBase64(@NotNull String[] payloads) {
        byte[][] decoded = new byte[payloads.length][];
        for (int i = 0; i < decoded.length; ++i) {
            decoded[i] = Base64.getDecoder().decode(payloads[i]);
        }
        return new BytesArrayList(decoded).stream();
    }

    @NotNull
    public static InputStream stream(@NotNull String[] payloads) {
        byte[][] bytes = new byte[payloads.length][];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = payloads[i].getBytes();
        }
        return new BytesArrayList(bytes).stream();
    }

    private void ensureExplicitCapacity(int minCapacity) {
        if (minCapacity - this.elementData.length > 0) {
            this.grow(minCapacity);
        }
    }

    public void add(byte[] e) {
        this.ensureExplicitCapacity(this.size + 1);
        this.elementData[this.size++] = e;
    }

    public byte[] get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(String.format("size: %d, index: %d", this.size, index));
        }
        return this.elementData[index];
    }

    public byte[][] toArray() {
        return (byte[][])Arrays.copyOfRange(this.elementData, 0, this.size);
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.elementData.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        this.elementData = (byte[][])Arrays.copyOf(this.elementData, newCapacity);
    }

    @NotNull
    public BytesArrayList copyOfRange(int from, int to) {
        return new BytesArrayList((byte[][])Arrays.copyOfRange(this.elementData, from, to));
    }

    public int size() {
        return this.size;
    }

    @Override
    @NotNull
    public Iterator<byte[]> iterator() {
        return new Itr();
    }

    public String toString() {
        return this.toHex();
    }

    @NotNull
    public String toHex() {
        Object[] array = new String[this.size()];
        byte[][] copy = this.toArray();
        for (int i = 0; i < copy.length; ++i) {
            array[i] = Utils.bytesToHex((byte[])copy[i]);
        }
        return Arrays.toString(array);
    }

    @NotNull
    public InputStream stream() {
        return new InternalStream();
    }

    @NotNull
    public String readIntoString(int index) {
        byte[] b = this.get(index);
        return new String(b);
    }

    private class Itr
    implements Iterator<byte[]> {
        int cursor = 0;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != BytesArrayList.this.size();
        }

        @Override
        public byte[] next() {
            try {
                int i = this.cursor;
                byte[] next = BytesArrayList.this.get(i);
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new NoSuchElementException();
            }
        }
    }

    private class InternalStream
    extends InputStream {
        private int offset = 0;
        private int sub = 0;

        private InternalStream() {
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) {
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.sub >= BytesArrayList.this.elementData.length) {
                return -1;
            }
            int i = 0;
            while (true) {
                int copy = Math.min(len - i, BytesArrayList.this.elementData[this.sub].length - this.offset);
                System.arraycopy(BytesArrayList.this.elementData[this.sub], this.offset, b, off + i, copy);
                this.offset += copy;
                if ((i += copy) == len) {
                    return i;
                }
                if (this.offset < BytesArrayList.this.elementData[this.sub].length) continue;
                this.offset = 0;
                if (++this.sub >= BytesArrayList.this.elementData.length) break;
            }
            return i == 0 ? -1 : i;
        }

        @Override
        public synchronized int read() {
            if (this.sub >= BytesArrayList.this.elementData.length) {
                return -1;
            }
            if (this.offset >= BytesArrayList.this.elementData[this.sub].length) {
                this.offset = 0;
                if (++this.sub >= BytesArrayList.this.elementData.length) {
                    return -1;
                }
            }
            return BytesArrayList.this.elementData[this.sub][this.offset++] & 0xFF;
        }
    }
}

