/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot.crypto;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Packet {
    public final byte cmd;
    public final byte[] payload;
    private Type type = null;

    Packet(byte cmd, byte[] payload) {
        this.cmd = cmd;
        this.payload = payload;
    }

    @Nullable
    public Type type() {
        if (this.type == null) {
            this.type = Type.parse(this.cmd);
        }
        return this.type;
    }

    public boolean is(@NotNull Type type) {
        return this.type() == type;
    }

    public static enum Type {
        SecretBlock(2),
        Ping(4),
        StreamChunk(8),
        StreamChunkRes(9),
        ChannelError(10),
        ChannelAbort(11),
        RequestKey(12),
        AesKey(13),
        AesKeyError(14),
        Image(25),
        CountryCode(27),
        Pong(73),
        PongAck(74),
        Pause(75),
        ProductInfo(80),
        LegacyWelcome(105),
        LicenseVersion(118),
        Login(171),
        APWelcome(172),
        AuthFailure(173),
        MercuryReq(178),
        MercurySub(179),
        MercuryUnsub(180),
        MercuryEvent(181),
        UnknownData_AllZeros(31),
        PreferredLocale(116),
        Unknown_0x4f(79),
        Unknown_0x0f(15),
        Unknown_0x10(16);

        public final byte val;

        private Type(int val) {
            this.val = (byte)val;
        }

        @Nullable
        public static Type parse(byte val) {
            for (Type cmd : Type.values()) {
                if (cmd.val != val) continue;
                return cmd;
            }
            return null;
        }

        public static Type forMethod(@NotNull String method) {
            switch (method) {
                case "SUB": {
                    return MercurySub;
                }
                case "UNSUB": {
                    return MercuryUnsub;
                }
            }
            return MercuryReq;
        }
    }
}

